/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.event;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class VWToolbarMouseAdapter
extends MouseAdapter
implements ActionListener,
IVWToolbarActionListener {
    public static final int MAIN_TOOLBAR = 1;
    public static final int MAP_TOOLBAR = 2;
    public static final int STATUS_BAR = 4;
    public static final int ALL = 7;
    private Component m_container = null;
    private VWToolbarActionNotifier m_toolbarActionNotifier = null;
    private JPopupMenu m_popupMenu = null;
    private JCheckBoxMenuItem m_mainToolbarMenuItem = null;
    private JCheckBoxMenuItem m_mapToolbarMenuItem = null;
    private JCheckBoxMenuItem m_statusBarMenuItem = null;

    public VWToolbarMouseAdapter(Component container, int nFlags, VWToolbarActionNotifier toolbarActionNotifier) {
        VWDebug.nullCheck(container);
        this.m_container = container;
        VWDebug.nullCheck(toolbarActionNotifier);
        this.m_toolbarActionNotifier = toolbarActionNotifier;
        if (this.m_popupMenu == null) {
            this.m_popupMenu = new JPopupMenu();
            if ((nFlags & 1) != 0) {
                this.m_mainToolbarMenuItem = new JCheckBoxMenuItem(VWResource.s_mainToolbarStr);
                this.m_mainToolbarMenuItem.setSelected(true);
                this.m_mainToolbarMenuItem.addActionListener(this);
                this.m_popupMenu.add(this.m_mainToolbarMenuItem);
            }
            if ((nFlags & 2) != 0) {
                this.m_mapToolbarMenuItem = new JCheckBoxMenuItem(VWResource.s_submapToolbarStr);
                this.m_mapToolbarMenuItem.setSelected(true);
                this.m_mapToolbarMenuItem.addActionListener(this);
                this.m_popupMenu.add(this.m_mapToolbarMenuItem);
            }
            if ((nFlags & 4) != 0) {
                this.m_statusBarMenuItem = new JCheckBoxMenuItem(VWResource.s_statusBarStr);
                this.m_statusBarMenuItem.setSelected(true);
                this.m_statusBarMenuItem.addActionListener(this);
                this.m_popupMenu.add(this.m_statusBarMenuItem);
            }
        }
        this.m_toolbarActionNotifier.addToolbarActionListener(this);
    }

    public void removeReferences() {
        this.m_container = null;
        if (this.m_popupMenu != null) {
            this.m_popupMenu.removeAll();
            this.m_popupMenu = null;
        }
        if (this.m_mainToolbarMenuItem != null) {
            this.m_mainToolbarMenuItem.removeActionListener(this);
            this.m_mainToolbarMenuItem = null;
        }
        if (this.m_mapToolbarMenuItem != null) {
            this.m_mapToolbarMenuItem.removeActionListener(this);
            this.m_mapToolbarMenuItem = null;
        }
        if (this.m_statusBarMenuItem != null) {
            this.m_statusBarMenuItem.removeActionListener(this);
            this.m_statusBarMenuItem = null;
        }
        this.m_toolbarActionNotifier.removeToolbarActionListener(this);
        this.m_toolbarActionNotifier = null;
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getPoint());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getPoint());
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_mainToolbarMenuItem) {
            this.performMainToolbarAction(this.m_mainToolbarMenuItem.isSelected(), true);
        } else if (src == this.m_mapToolbarMenuItem) {
            this.performMapToolbarAction(this.m_mapToolbarMenuItem.isSelected(), true);
        } else if (src == this.m_statusBarMenuItem) {
            this.performStatusBarAction(this.m_statusBarMenuItem.isSelected(), true);
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 600: {
                this.performMainToolbarAction(true, false);
                break;
            }
            case 601: {
                this.performMainToolbarAction(false, false);
                break;
            }
            case 602: {
                this.performMapToolbarAction(true, false);
                break;
            }
            case 603: {
                this.performMapToolbarAction(false, false);
                break;
            }
            case 604: {
                this.performStatusBarAction(true, false);
                break;
            }
            case 605: {
                this.performStatusBarAction(false, false);
            }
        }
    }

    protected void showPopupMenu(Point point) {
        if (this.m_container != null && this.m_popupMenu != null) {
            this.m_popupMenu.show(this.m_container, point.x, point.y);
        }
    }

    private void performMainToolbarAction(boolean bShow, boolean bNotify) {
        if (this.m_mainToolbarMenuItem != null) {
            this.m_mainToolbarMenuItem.setSelected(bShow);
        }
        if (bNotify) {
            this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 600 : 601);
        }
    }

    private void performMapToolbarAction(boolean bShow, boolean bNotify) {
        this.m_mapToolbarMenuItem.setSelected(bShow);
        if (bNotify) {
            this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 602 : 603);
        }
    }

    private void performStatusBarAction(boolean bShow, boolean bNotify) {
        this.m_statusBarMenuItem.setSelected(bShow);
        if (bNotify) {
            this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 604 : 605);
        }
    }
}

